<?php

class ShowSimilarThreads_Model_SimilarThreads extends XenForo_Model
{
	public function getSimilarThreads($forum, $query, $excludedThreadId = 0)
	{
		return $this->getSimilarThreadsByIds($this->getSimilarThreadIds($forum, $query, $excludedThreadId), $forum);
	}
	
	public function getSimilarThreadsByIds($threadIds, $forum)
	{
		$threads = $this->getModelFromCache('XenForo_Model_Thread')->getThreadsByIds($threadIds, array('join' => XenForo_Model_Thread::FETCH_FORUM | XenForo_Model_Thread::FETCH_AVATAR));
		
		foreach($threads AS $key => &$thread)
		{
			$permissions = XenForo_Visitor::getInstance()->getNodePermissions($thread['node_id']);
			
			$thread = $this->getModelFromCache('XenForo_Model_Thread')->prepareThread($thread, $forum, $permissions);
			
			if (!$this->getModelFromCache('XenForo_Model_Thread')->canViewThread($thread, $thread, $null, $permissions))
			{
				unset($threads[$key]);
			}
		}
		
		return $threads;
	}
	
	public function getSimilarThreadIds($forum, $query, $excludedThreadId = 0)
	{
		$threadIds = array();
		
		if ($query)
		{
			if (XenForo_Application::get('options')->enableElasticsearch)
			{
				$searchModel = $this->getModelFromCache('XenForo_Model_Search');
				$typeHandler = $searchModel->getSearchDataHandler('thread');
				$searcher = new XenForo_Search_Searcher($searchModel, new ShowSimilarThreads_Search_SourceHandler_ElasticSearch());
				
				$constraints = array('title_only' => 1);
				if (!XenForo_Application::get('options')->showSimilarThreadsGlobal)
				{
					$constraints['node'] = $forum['node_id'];
				}
				
				$results = $searcher->searchType(
					$typeHandler, $query, $constraints, 'relevance', false, 6
				);
				
				foreach ($results AS $result)
				{
					if ($result[1] != $excludedThreadId)
					{
						$threadIds[] = $result[1];
					}
				}
				
				if (count($threadIds) > 5)
				{
					unset($threadIds[5]);
				}
			}
			else
			{
				$sql = '
					SELECT xf_search_index.content_id, MATCH(xf_search_index.title, xf_search_index.metadata) AGAINST (?) AS score
					FROM xf_search_index
					LEFT JOIN xf_thread
						ON (xf_thread.thread_id = xf_search_index.content_id)
					WHERE MATCH(xf_search_index.title, xf_search_index.metadata) AGAINST (?)
						AND content_type = ?
						AND content_id != ?
				';
				
				$params = array($query, $query, 'thread', $excludedThreadId);
				if (!XenForo_Application::get('options')->showSimilarThreadsGlobal)
				{
					$params[] = $forum['node_id'];
					$sql .= 'AND xf_thread.node_id = ?
					';
				}
				
				$sql .= 'LIMIT 5';
				
				$results = $this->fetchAllKeyed($sql, 'content_id', $params);
				
				$threadIds = array_keys($results);
			}
		}
		
		return $threadIds;
	}
}